CONTAINER fx_particleattach
{
	NAME fx_particleattach;
	INCLUDE Obase;

	//Basic Tab
	GROUP ID_OBJECTPROPERTIES
	{			
		DEFAULT 1;
		BOOL PATTACH_RENDERONLY {}
		LINK PATTACH_LINK {ACCEPT{fx_fluidsim;fx_particle;}; }

		LONG PATTACH_FLUID_PARTICLETYPE
		{
			CYCLE
			{
				PATTACH_FLUID_PARTICLETYPE_FP;
				PATTACH_FLUID_PARTICLETYPE_VP;
				PATTACH_FLUID_PARTICLETYPE_FOAM;
				PATTACH_FLUID_PARTICLETYPE_BUBBLES;
				PATTACH_FLUID_PARTICLETYPE_IMPLICIT;
			}
		}
		
		LONG PATTACH_INSTANCE
		{
			CYCLE
			{
				PATTACH_INSTANCE_ORIG;
				PATTACH_INSTANCE_INSTANCE;
				PATTACH_INSTANCE_RENDERINSTANCE;
				//PATTACH_INSTANCE_TP;
			}
		}	
	}		
	GROUP PATTACH_GENERATION
	{
		LONG PATTACH_SPLIT { MIN 10000; }
		LONG PATTACH_SPLITPART { MIN 1; MAX 1000; }
		GROUP PATTACH_CLOUD_SID
		{
			COLUMNS 2;
			LONG PATTACH_CLOUDCNT {	MIN 0; }
			REAL PATTACH_CLOUDCNT_VAR { MIN 0; MAX 100; UNIT PERCENT;}
			REAL PATTACH_CLOUDOFFSET { UNIT METER; }			
			REAL PATTACH_CLOUDOFFSET_VAR { MIN 0; MAX 100; UNIT PERCENT;}

			REAL PATTACH_CLOUD_ADVECTION {MIN -1.0; MAX 1.0;}
		}

		GROUP PATTACH_DIMENSIONS
		{
			VECTOR	 PATTACH_SCALE	{MIN 0 0 0;}
			VECTOR	 PATTACH_VELSCALE {MIN 0 0 0; UNIT PERCENT;}
			LONG	PATTACH_SCALE_FPBASE	
			{
				CYCLE
				{
					PATTACH_SCALE_FPBASE_OFF;
					PATTACH_SCALE_FPBASE_PRAD;
					PATTACH_SCALE_FPBASE_SMOKE;
					PATTACH_SCALE_FPBASE_VELOCITY;
					PATTACH_SCALE_FPBASE_TEMP;
					PATTACH_SCALE_FPBASE_FUEL;
					//PATTACH_SCALE_FPBASE_SIMSMOKE;
					//PATTACH_SCALE_FPBASE_SIMTEMP;
					//PATTACH_SCALE_FPBASE_SIMFUEL;
					//PATTACH_SCALE_FPBASE_SIMFIRE;
				}
			}
			LONG	PATTACH_SCALE_VPBASE	
			{
				CYCLE
				{
					PATTACH_SCALE_VPBASE_OFF;
					PATTACH_SCALE_VPBASE_PRAD;
					PATTACH_SCALE_VPBASE_VORTICITY;
					PATTACH_SCALE_VPBASE_VELOCITY;
				}
			}
			LONG	PATTACH_SCALE_SPBASE	
			{
				CYCLE
				{
					PATTACH_SCALE_SPBASE_OFF;
					PATTACH_SCALE_SPBASE_PRAD;
					PATTACH_SCALE_SPBASE_VELOCITY;
				}
			}
			REAL	PATTACH_SCALE_PRAD	{MIN 0; UNIT METER;}
			REAL	PATTACH_SCALE_VAR	{MIN 0; MAX 100; UNIT PERCENT;}

			GRADIENT PATTACH_SCALE_AGEX {ALPHA;ANIM ON;}
			GRADIENT PATTACH_SCALE_AGEY {ALPHA;ANIM ON;}
			GRADIENT PATTACH_SCALE_AGEZ {ALPHA;ANIM ON;}
		}
		GROUP PATTACH_ROTATION
		{			
			LONG PATTACH_ALIGNMENT 
			{
				CYCLE
				{
					PATTACH_ALIGNMENT_X;
					PATTACH_ALIGNMENT_Y;
					PATTACH_ALIGNMENT_Z;
					PATTACH_ALIGNMENT_TANGENT;
					PATTACH_ALIGNMENT_BILLBOARD;
					PATTACH_ALIGNMENT_NORMAL;
				}
			}
			VECTOR PATTACH_BILLOW	{MIN -360 -360 -360; MAX 360 360 360; UNIT DEGREE;}
			LONG	PATTACH_BILLOW_FPBASE	
			{
				CYCLE
				{
					PATTACH_BILLOW_FPBASE_OFF;
					PATTACH_BILLOW_FPBASE_PRAD;
					PATTACH_BILLOW_FPBASE_SMOKE;
					PATTACH_BILLOW_FPBASE_VELOCITY;
					PATTACH_BILLOW_FPBASE_TEMP;
					PATTACH_BILLOW_FPBASE_FUEL;
				}
			}
			LONG	PATTACH_BILLOW_VPBASE	
			{
				CYCLE
				{
					PATTACH_BILLOW_VPBASE_OFF;
					PATTACH_BILLOW_VPBASE_PRAD;
					PATTACH_BILLOW_VPBASE_VORTICITY;
					PATTACH_BILLOW_VPBASE_VELOCITY;
				}
			}
			LONG	PATTACH_BILLOW_SPBASE	
			{
				CYCLE
				{
					PATTACH_BILLOW_SPBASE_OFF;
					PATTACH_BILLOW_SPBASE_PRAD;
					PATTACH_BILLOW_SPBASE_VELOCITY;
				}
			}
			REAL	PATTACH_BILLOW_PRAD	{MIN 0; UNIT METER;}
			REAL	PATTACH_BILLOW_VAR	{MIN 0; MAX 100; UNIT PERCENT;}
			SPLINE	PATTACH_BILLOW_VARSEED	
			{
				SHOWGRID_H; 
													  
				X_MIN 0; 
				X_MAX 1; 
									  
				Y_MIN 0; 
				Y_MAX 1; 
									  
				X_STEPS 0.01; 
				Y_STEPS 0.01; 
			}

			GRADIENT PATTACH_BILLOW_AGEX {ALPHA;ANIM ON;}
			GRADIENT PATTACH_BILLOW_AGEY {ALPHA;ANIM ON;}
			GRADIENT PATTACH_BILLOW_AGEZ {ALPHA;ANIM ON;}
		}
		GROUP PATTACH_PROPERTIES
		{			
			//FLUID PARTICLES
			LONG PATTACH_FLUIDGROUP
			{
				CYCLE
				{
					PATTACH_FLUIDGROUP_ALL;
				}
			}
			BOOL PATTACH_SETCOLOR {}

			//VORTICITY PARTICLES
			LONG PATTACH_SUBGRIDLAYER 
			{
				CYCLE
				{	
					PATTACH_SUBGRIDLAYER_PARENT;
				}
			}
		}
	}
	
}